<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model 
{

    protected $table = 'invoices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function order()
    {
        return $this->belongsTo('App\Models\Order');
    }

    public function logs()
    {
        return $this->morphMany('App\Models\Log');
    }

    public function events()
    {
        return $this->morphMany('App\Models\Event');
    }

}